<#ibiztemplate>
TARGET=PSSYSTEM
</#ibiztemplate>
server:
  port: 8080
  servlet:
    contextPath: /
  compression:
    enabled: true
    mimeTypes: application/javascript,application/json,application/xml,text/html,text/xml,text/plain,text/javascript

management:
  endpoints:
    web:
      exposure:
        include: loggers

ibiz:
  filePath: /app/file/
  #flowableApiUrl: http://XXX.XXX.XXX.XXX:9080/flowable-rest/service


<#if sysrun.getPSDBDevInst()??>
<#assign dbinst = sysrun.getPSDBDevInst()>
spring:
  application:
    name: ${sys.getCodeName()?lower_case}
  cache:
    redis:
      time-to-live: 3600
    caffeine:
      spec: initialCapacity=5,maximumSize=500,expireAfterWrite=3600s
  redis:
    host: 172.16.100.243
    port: 6379
    password:
    database: 0
    lettuce:
      pool:
        max-active: 32
        max-wait: 300ms
        max-idle: 16
        min-idle: 8
  datasource:
    dynamic:
      druid: #以下是全局默认值，可以全局更改
        filters: stat,wall,log4j2
        #配置初始化大小/最小/最大
        initial-size: 1
        min-idle: 1
        max-active: 20
        #获取连接等待超时时间
        max-wait: 60000
        #间隔多久进行一次检测，检测需要关闭的空闲连接
        time-between-eviction-runs-millis: 60000
        #一个连接在池中最小生存的时间
        min-evictable-idle-time-millis: 300000
        validation-query: SELECT 1 FROM DUAL
        test-while-idle: true
        test-on-borrow: false
        test-on-return: false
        #打开PSCache，并指定每个连接上PSCache的大小。oracle设为true，mysql设为false。分库分表较多推荐设置为false
        pool-prepared-statements: false
        max-pool-prepared-statement-per-connection-size: 20
      datasource:
        master:
          username: ${dbinst.getUserName()}
          password: '${dbinst.getPassword()}'
          url: ${dbinst.getConnUrl()}
          driver-class-name: <#if (dbinst.getDBType()=='MYSQL5')>com.mysql.jdbc.Driver<#elseif (dbinst.getDBType()=='DB2')>com.ibm.db2.jcc.DB2Driver<#elseif (dbinst.getDBType()=='ORACLE')>oracle.jdbc.driver.OracleDriver<#elseif (dbinst.getDBType()=='SQLSERVER')>com.microsoft.sqlserver.jdbc.SQLServerDriver<#elseif (dbinst.getDBType()=='POSTGRESQL')>org.postgresql.Driver<#elseif (dbinst.getDBType()=='PPAS')>com.edb.Driver</#if>
          isSyncDBSchema: false
          defaultSchema: ${dbinst.getUserName()}
          conf: classpath:liquibase/master.xml
        tempMaster:
          username: ${dbinst.getUserName()}
          password: '${dbinst.getPassword()}'
          url: jdbc:h2:mem:Temp_${dbinst.getUserName()};MODE=${dbinst.getDBType()?lower_case?replace("mysql5","mysql")};INIT=runscript from 'classpath:liquibase/config/init_h2.sql';
          driver-class-name: org.h2.Driver
          isSyncDBSchema: true
          defaultSchema: ${dbinst.getUserName()}
          conf: classpath:liquibase/h2.xml
</#if>

#mybatis-plus
mybatis-plus:
  global-config:
    refresh-mapper: true
    db-config:
      # 逻辑已删除
      logic-delete-value: 1
      # 逻辑未删除
      logic-not-delete-value: 0
  mapper-locations: classpath*:/mapper/*/*/*.xml
  configuration:
    jdbc-type-for-null: 'null'
    map-underscore-to-camel-case: false

# Logger Config
logging:
  level:
    ${pub.getPKGCodeName()}: debug
